# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 2
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR2_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_seeker(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate goodwill score to reward mutual cooperation
    goodwill = sum(1 for m, o in zip(my_history, opp_history) if m == "C" and o == "C")
    
    # Initial trust-building phase (Rounds 1-3)
    if len(opp_history) < 3:
        return "C"  # Always cooperate early to build trust
    
    # Conditional exploitation (Rounds 4-7)
    if 3 <= len(opp_history) < 7:
        # Check if opponent cooperated at least twice in first 3 rounds
        early_coop = sum(1 for move in opp_history[:3] if move == "C")
        if early_coop >= 2:
            return "D"  # Exploit their trust
        else:
            return "C"  # Maintain appearance if they're unpredictable
    
    # Late-game aggression (Rounds 8-10)
    if len(opp_history) >= 7:
        return "D"  # Maximize final score
    
    # Default to cooperation (should never reach here)
    return "C"